# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#  Package Definition File:  SLES 9
#
# The following variables must be set before including this file:
#  $::mgmt_type   = MgmtServer | MgdNode
#  $::csm_version = 1.2.0, 1.3.0, 1.3.1, 1.3.2, 1.3.3, etc.
# @(#)91   1.11   src/csm/install/pkgdefs/Linux-SLES9-x86_64.pm.perl, setup, csm_rameh, rameh_base 7/6/04 06:59:36


package SLES9;
do "/opt/csm/install/pkgdefs/Linux.pm";

#  Load base Linux definitions:
#require "/opt/csm/install/pkgdefs/linux";

NodeUtils->messageFromCat('csmInstall.cat',$::MSGMAPPATH,'csminstall','V', 'IMsgLoading', "/opt/csm/install/pkgdefs/Linux-SLES9-x86_64.pm");

my $_server_='MgmtServer';
my $_node_='MgdNode';

$::pkgdefs{DISTRO_NAME}        = "SuSE SLES 9 x86_64";
$::pkgdefs{DISTRO_DISKLIST}    = "1 2 3";		# TO BE REMOVED
$::pkgdefs{DISTRO_RPMDIR}      = "suse";

# Distribution Disk descriptions used when prompting for the CD-ROMs
# On stanza per CDROM:
#   num                 = the number on the CD-ROM's label
#   name                = the text string describing the CD-ROM
my $dd_ref = [
	{
	    num			=> '1',
	    name		=> $::pkgdefs{DISTRO_NAME},
	    diskid_searchargs	=> {
		    file=>	'media.1/products',
		    key =>	'/ SUSE-Linux-SLES-x86-64 9',
	    },
	    diskid_searchprog	=> \&Linux::linux_diskid_match_prog,
	    diskid_target	=> 'sles9-x86_64',
	},
	{
	    num			=> '1',
	    name		=> "SuSE Linux CORE 9 x86_64",
	    diskid_searchargs	=> {
		    file=>	'media.1/products',
		    key =>	'/ SUSE-Linux-CORE-x86-64 9',
	    },
	    diskid_searchprog	=> \&Linux::linux_diskid_match_prog,
	    diskid_target	=> 'sles9-core-x86_64',
	},
        {
            num                 => '2',
            name                => "SuSE Linux CORE 9 x86_64",
            diskid_searchargs   => {
                    file=>      'media.2/products',
                    key =>      '/ SUSE-Linux-CORE-x86-64 9',
            },
            diskid_searchprog   => \&Linux::linux_diskid_match_prog,
            diskid_target       => 'sles9-core-x86_64',
        }
	];
$::pkgdefs{distro_disks}	= $dd_ref;

# Open Source Prereqs to Install
my $opr_ref;
$opr_ref{$_server_}{$::csm_version}
	    = ['tftp-hpa','IBMJava2-JRE-1.4.1','conserver','fping'];
$opr_ref{$_node_}{'1.2.0'} = [];
$opr_ref{$_node_}{$::csm_version} = ['autoupdate'];

$::pkgdefs{opensrc_prereqs} = $opr_ref{$::mgmt_type}{$::csm_version};


# RSCT Packages to Install
my $rsct_packages;
$rp_ref{$_server_}{$::csm_version}
	    = ['src','rsct.core.utils','rsct.core','rsct.basic', 'rsct.core.cimrm'];
$rp_ref{$_node_}{$::csm_version}
	    = ['src','rsct.core.utils','rsct.core','rsct.basic', 'rsct.core.cimrm'];

$rp_ref{$_node_}{'1.2.0'} = 
   ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
$rp_ref{$_node_}{'1.3.0'} = 
   ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
$rp_ref{$_node_}{'1.3.1'} = 
   ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
$rp_ref{$_node_}{'1.3.2'} = 
   ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];

$::pkgdefs{rsct_packages} = $rp_ref{$::mgmt_type}{$::csm_version};


# CSM Packages to Install
my $cp_ref;
$cp_ref{$_server_}{$::csm_version}
	    = ['csm.core','csm.dsh','csm.server','csm.diagnostics',
	       'csm.gui.dcem'];
$cp_ref{$_node_}{'1.2.0'}
	    = ['csm.core','csm.client'];
$cp_ref{$_node_}{$::csm_version}
	    = ['csm.core','csm.client','csm.diagnostics'];
$::pkgdefs{csm_packages} = $cp_ref{$::mgmt_type}{$::csm_version};

# Director Packages to Install
my $dp_ref;
$dp_ref{$_server_}{$::csm_version}
	    = ['csm.director.agent','csm.director.server'];
$dp_ref{$_node_}{$::csm_version}
	    = ['csm.director.agent','csm.director.server'];
$dp_ref{$_node_}{'1.2.0'}=[];
$dp_ref{$_node_}{'1.3.0'}=[];
$::pkgdefs{director_packages} = $dp_ref{$::mgmt_type}{$::csm_version};


# Packages to uninstall
my $rup_ref;
$rup_ref{$_server_}{$::csm_version} = 
  ['src','rsct.core.utils','rsct.core', 'rsct.core.cimrm'];
$rup_ref{$_node_}{$::csm_version} = 
  ['src','rsct.core.utils','rsct.core','rsct.core.cimrm'];

$rup_ref{$_node_}{'1.2.0'} = 
  ['src', 'rsct.core.utils', 'rsct.core'];
$rup_ref{$_node_}{'1.3.0'} = 
  ['src', 'rsct.core.utils', 'rsct.core'];
$rup_ref{$_node_}{'1.3.1'} = 
  ['src', 'rsct.core.utils', 'rsct.core'];
$rup_ref{$_node_}{'1.3.2'} = 
  ['src', 'rsct.core.utils', 'rsct.core'];

$::pkgdefs{rsct_unpackages} = $rup_ref{$::mgmt_type}{$::csm_version};

my $cup_ref;
$cup_ref{$_server_}{$::csm_version}
	    = ['csm.dsh','csm.server','csm.diagnostics','csm.gui.dcem'];
$cup_ref{$_node_}{'1.2.0'}
	    = ['csm.core','csm.client'];
$cup_ref{$_node_}{$::csm_version}
	    = ['csm.core','csm.diagnostics','csm.client'];
$::pkgdefs{csm_unpackages} = $cup_ref{$::mgmt_type}{$::csm_version};

# Directories to uninstall from the management server
# This variable used to be named csmUnistallList_dir
my $cud_ref;
$cud_ref{$_server_}{$::csm_version}=['/csminstall','/cfmroot'];
$cud_ref{$_node_}{$::csm_version}=[];
$::pkgdefs{csm_uninstall_dirs} = $cud_ref{$::mgmt_type}{$::csm_version};

# Packages to NOT uninstall
# This variable used to be named csmUnistallList_pack
my $cnip_ref;
$cnip_ref{$_server_}{$::csm_version}=['csm.core'];
$cnip_ref{$_node_}{$::csm_version}=[];
$::pkgdefs{csm_nouninstall_pkgs} = $cnip_ref{$::mgmt_type}{$::csm_version};


# Operating System pre-requisites
# This variable used to be named Linux_os_prereqs
# NOTE:  These variable names have changed slightly.  Now, both are merged
#        into os_prereqs, and there is a $::mgmt_type argument.  The
#        Linux_client_os_prereqs array is gone.
#        Changes required in installms, copycsmpkgs and makenode
my $ospr_ref;
$ospr_ref{$_server_}=['perl-5*','nfs-utils-*','pdksh-*','dhcp-*','dhcp-server-*','rdist-6.1.5-*','tcl-8*','tk-8*','expect-5.40-*','XFree86-*','freetype2-*','termcap-*','expat-*','perl-XML-Parser-*','perl-XML-DOM-*','perl-HTML-Tagset-*','perl-HTML-Parser-*','perl-URI-*','perl-libwww-perl-*','perl-XML-RegExp-*','syslinux-2*'];
$ospr_ref{$_node_}=['perl-5*','nfs-utils-*','pdksh-*','dhcp-*','dhcp-server-*','rdist-6.1.5-*','tcl-8*','tk-8*','expect-5.40-*','XFree86-*','freetype2-*','rsh-server-*'];
$::pkgdefs{os_prereqs} = $ospr_ref{$::mgmt_type};

my $ge_ref=('bin/grep','sbin/ifconfig','bin/sed','bin/sleep','bin/bash');
$::pkgdefs{getmacs_Exec}= $ge_ref;

my $gl_str= '/lib64';
$::pkgdefs{getmacs_Lib}=$gl_str;

my $gr_def=('/lib64/ld-linux-x86-64.so.2','/lib64/libc.so.6','/lib64/libdl.so.2','/lib64/libreadline.so.4','/lib64/libhistory.so.4','/lib64/libncurses.so.5','/lib64/libm.so.6','/lib64/libpthread.so.0','/lib64/librt.so.1');
$::pkgdefs{getmacs_ReqLibs}=$gr_def;

my $gd_ref=("bin","etc","linuxrc","modules","proc","linuxrc.config","kbd","tmp","var","root","mounts","mnt","devz","sbin","lib","sys");
$::pkgdefs{getmacs_DirStructure}=$gd_ref;

1;  # end
